<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'gradereport_grader', language 'en'
 *
 * @package   gradereport_grader
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['clearsearch'] = 'Clear searched users';
$string['collapsedcolumns'] = 'Collapsed columns <span class="badge badge-pill badge-primary ml-1" data-collapse="count">{$a}</span>';
$string['editingmode_title'] = 'Editing the grader report';
$string['eventgradereportviewed'] = 'Grader report viewed';
$string['grader:manage'] = 'Manage the grader report';
$string['grader:view'] = 'View grader report';
$string['pluginname'] = 'Grader report';
$string['preferences'] = 'Grader report preferences';
$string['privacy:metadata:preference:grade_report_aggregationposition'] = 'Whether the category and course total columns are displayed first or last in the gradebook reports';
$string['privacy:metadata:preference:grade_report_averagesdecimalpoints'] = 'The number of decimal places to display for each average or whether the overall decimal places setting for the category or grade item is used (inherit).';
$string['privacy:metadata:preference:grade_report_averagesdisplaytype'] = 'Whether the average (mean) is displayed as real grades, percentages or letters, or whether the display type for the category or grade item is used (inherit).';
$string['privacy:metadata:preference:grade_report_grader_collapsed_categories'] = 'List of gradebook categories to be collapsed';
$string['privacy:metadata:preference:grade_report_meanselection'] = 'Whether cells with no grade should be included when calculating the average (mean) for each category or grade item';
$string['privacy:metadata:preference:grade_report_quickgrading'] = 'Whether to display a text input box for each grade, allowing many grades to be edited at the same time';
$string['privacy:metadata:preference:grade_report_rangesdecimalpoints'] = 'The number of decimal places to display for each range or whether the overall decimal places setting for the category or grade item is used (inherit)';
$string['privacy:metadata:preference:grade_report_rangesdisplaytype'] = 'Whether the range is displayed as real grades, percentages or letters, or whether the display type for the category or grade item is used (inherit)';
$string['privacy:metadata:preference:grade_report_showaverages'] = 'Whether to display an additional row with the average (mean) for each category and grade item';
$string['privacy:metadata:preference:grade_report_shownumberofgrades'] = 'Whether to display in brackets after each average the number of grades used when calculating the average';
$string['privacy:metadata:preference:grade_report_showonlyactiveenrol'] = 'Whether to display only active enrolled users (not suspended) in gradebook report or all the enrolled users';
$string['privacy:metadata:preference:grade_report_showranges'] = 'Whether to display an additional row with the range for each category and grade item';
$string['privacy:metadata:preference:grade_report_showuserimage'] = 'Whether to show the user\'s profile image next to the name';
$string['privacy:metadata:preference:grade_report_studentsperpage'] = 'The number of students displayed per page in the grader report';
$string['privacy:request:preference:grade_report_grader_collapsed_categories'] = 'You have some gradebook categories collapsed in the "{$a->name}" course';
$string['reopencolumn'] = 'Expand column {$a}';
$string['summarygrader'] = 'A table with the names of students in the first column, with assessable activities grouped by course and category across the top.';
$string['useractivitygrade'] = '{$a} grade';
$string['overriddengrade'] = 'Overridden grade';
$string['advancedgrading'] = 'View {$a} results';
$string['cellactions'] = 'Cell actions';
$string['viewallresults'] = 'View all results ({$a})';
$string['viewresultsuser'] = 'View results for {$a}';

// Deprecated since Moodle 4.2.
$string['privacy:metadata:preference:grade_report_showanalysisicon'] = 'Whether to show grade analysis icon by default. If the activity module supports it, the grade analysis icon links to a page with more detailed explanation of the grade and how it was obtained.';
$string['privacy:metadata:preference:grade_report_showeyecons'] = 'Whether to display the show/hide icon for each grade for controlling its visibility to the student';
$string['privacy:metadata:preference:grade_report_showlocks'] = 'Whether to display a lock/unlock icon for each grade for controlling if the grade can be automatically updated by the related activity when editing is turned on';
$string['privacy:metadata:preference:grade_report_showquickfeedback'] = 'Whether to display a feedback text input box with a dotted border for each grade, allowing the feedback for many grades to be edited at the same time';
$string['privacy:metadata:preference:grade_report_enableajax'] = 'Whether to add a layer of AJAX functionality to the grader report, simplifying and speeding up common operations';
$string['useractivityfeedback'] = '{$a} feedback';
$string['ajaxclicktoclose'] = 'Click this box to remove it';
$string['ajaxerror'] = 'Error';
$string['ajaxfailedupdate'] = 'Unable to update [1] for [2]';
$string['ajaxfieldchanged'] = 'The field you are currently editing has changed, would you like to use the updated value?';
$string['ajaxchoosescale'] = 'Choose';
$string['privacy:metadata:preference:grade_report_showactivityicons'] = 'Whether to show the activity icons next to activity names';
$string['privacy:metadata:preference:grade_report_showcalculations'] = 'Whether a calculator icon for each grade item and category with a visual indicator that a grade item is calculated is displayed or not when editing is turned on';
